
import matplotlib.pyplot as plt
import numpy as np

# python note: you can make a list such as lt_day90_list=[...] but then you can't do math operations, so we use arrays
# the data: local times for Ls 90
lt_day90 = np.array([0.095020294, 0.59453964, 1.095089, 1.5952148, 2.0952778, 2.5947971, 3.0948582, 3.5954075, 4.0954685, 4.59499, 5.095537, 5.595663, 6.095724, 6.5952454, 7.0953064, 7.595854, 8.095375, 8.595436, 9.095987, 9.596113, 10.095633, 10.595694, 11.095755, 11.596304, 12.095823, 12.595882, 13.096432, 13.596558, 14.096079, 14.59614, 15.096199, 15.59675, 16.09627, 16.59633, 17.096878, 17.597006, 18.096525, 18.596588, 19.096645, 19.597197, 20.096718, 20.596777, 21.097326, 21.597452, 22.096973, 22.597033, 23.097094, 23.597643 ])
# temperatures for Ls 90
temp_day90 =np.array([194.44699, 193.28142, 192.1042, 191.04657, 189.89449, 189.07349, 187.04427, 186.11755, 185.99585, 184.9547, 184.33585, 183.49182, 186.07129, 193.28436, 201.42188, 209.52034, 217.48729, 224.65692, 230.96461, 236.08624, 240.0209, 242.92247, 245.015, 246.36516, 246.95248, 246.73393, 245.89989, 244.50316, 242.36137, 239.43756, 237.9089, 235.60765, 232.22388, 226.4871, 220.34421, 213.84901, 207.37776, 210.18083, 209.33781, 207.09885, 205.93668, 203.13148, 202.39644, 200.88411, 199.574, 197.47536, 196.82799, 195.31184])
# data for Ls 270
lt_day270 =np.array([0.12906075, 0.62828636, 1.1290798, 1.6283054, 2.127594, 2.6278992, 3.1271267, 3.6279202, 4.127144, 4.6263695, 5.127163, 5.6263885, 6.125679, 6.625986, 7.12521, 7.6260033, 8.125229, 8.6244545, 9.12525, 9.624474, 10.123764, 10.624071, 11.123297, 11.62409, 12.123316, 12.6225395, 13.123333, 13.6225605, 14.121849, 14.622156, 15.12138, 15.621096, 16.1214, 16.620626, 17.12142, 17.620647, 18.119936, 18.620245, 19.119467, 19.619183, 20.11949, 20.618715, 21.119509, 21.618732, 22.118025, 22.618332, 23.117556, 23.617271])
temp_day270 = np.array([211.42342, 209.44066, 209.89647, 209.07275, 207.79657, 208.64192, 206.26147, 204.79929, 203.93922, 205.64609, 202.00517, 200.79428, 200.05583, 205.12627, 212.53241, 220.97614, 229.72737, 238.32108, 245.94974, 252.40285, 257.65924, 261.62122, 264.35785, 266.16125, 267.03983, 267.24582, 266.72498, 265.5559, 263.59802, 260.91653, 257.4726, 253.19023, 247.36111, 241.23454, 234.68393, 228.94266, 229.59903, 225.81084, 223.72592, 221.91483, 218.36212, 215.77905, 215.25156, 215.43932, 212.89781, 210.96632, 210.16853, 211.0748])

temp_day90 = temp_day90-273.15
temp_day270 = temp_day270-273.15

plt.plot(lt_day90,temp_day90,label="air temp Ls 90")

plt.plot(lt_day270,temp_day270,label="air temp Ls 270")

plt.xlabel('Local time')
plt.ylabel('Temperature (C)')

plt.grid()
plt.legend()
plt.show()

